hud_animate_speed = 8;
hud_animate_speed = 8;
hud_lower_offset = 144;

pause_button_spec = 
{
	name = "PAUSE_BUTTON";
	text = "";
	halo = "quest/objects/button_pause";
	position = { x = 717, y = 525 };
	image = "buttons/button_pause";
	depth = 50;
	rolloversound = "audio/sfx/pause_rollover";
	depth_mode = DEPTH.DEPTH_OVER_HUD;
	flags = AFLAG.AFLAG_ALWAYS_ACCEPT_CLICKS;
	
	on_click = function(flo, button)
		scene:PauseGame();
	end;
}

pause_button_help_spec = 
{
	name = "PAUSE_BUTTON_HELP";
	text = "";
	halo = "quest/objects/button_pause";
	position = { x = 730, y = 515+hud_lower_offset };
	image = "buttons/button_pause_help";
	depth = 50;
	rolloversound = "audio/sfx/pause_rollover";
	--depth_mode = DEPTH.DEPTH_OVER_HUD;
	flags = AFLAG.AFLAG_ALWAYS_ACCEPT_CLICKS;
	
	on_click = function(flo, button)
		scene:PauseGame();
	end;
}

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		help_panel_say_raw(scene:grabstring("instructions"));
	end;
}

pass_activity_button_spec = 
{
	name = "PASS_ACTIVITY_BUTTON";
	halo = "quest/objects/button_thin";
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	text = "pass";
	position = { x = 0, y = 450 };
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		flo:StartProc(pass_activity);
	end;
}

fail_activity_button_spec = 
{
	name = "FAIL_ACTIVITY_BUTTON";
	halo = "quest/objects/button_thin";
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	text = "fail";
	position = { x = 0, y = 475 };
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		flo:StartProc(fail_activity);
	end;
}

next_activity_button_spec = 
{
	name = "NEXT_ACTIVITY_BUTTON";
	text = "continue";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 560 };
	image = "buttons/button_thin";
	clicksound = "audio/sfx/buttonclick";
	rolloversound = "audio/sfx/button_rollover";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		flo:StartProc(next_activity);
	end;
}

reset_activity_button_spec = 
{
	name = "RESET_ACTIVITY_BUTTON";
	text = "reset";
	halo = "quest/objects/button_reset";
	position = { x = 584, y = 560 };
	image = "buttons/button_reset";
	clicksound = "audio/sfx/buttonclick";
	rolloversound = "audio/sfx/button_rollover";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 124,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		flo:StartProc(reset_activity);
	end;
}

back_button_spec = 
{
	name = "BACK_BUTTON";
	text = "back";
	halo = "quest/objects/back_button";
	position = { x = 0, y = 520+hud_lower_offset };
	image = "buttons/button_back";
	rolloversound = "audio/sfx/pause_rollover";
	say_spec =
		{
			color = { a = 1, r = 1, g = 1, b = 1 },
			color_over = { a = 1, r = 1, g = 1, b = 1 },
			y = 25,
			x = 0,
			w = 70,
			h = 20,
			bubble = false,
			lineheight = 15,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER,
			halign = HALIGN.CENTER,
			angle = 0.05,
		};
	on_click = function(flo, actor)
		if game:Get("activity_mode") == 1 then
			--sfx:SetMusic("audio/music/mainmenumusic.ogg", true);
			game:Set("activity_mode", 0);
			game:SaveGame();
			sfx:PlayMusic("audio/music/mainmenumusic", true);
			scene:QuitToLastMenu();
		else
			flo:StartProc(go_back);
		end
	end;
}

function napkin_button_click(actor, minigame)
	lower_hud();
	while not hud_lowered() do
		delay(1);
	end
	scene:ChainToSubScene("napkin");
	wait_subscene();
	
	if not minigame then
		raise_hud();
	end
end

napkin_button_spec = 
{
	name = "NAPKIN_BUTTON";
	text = "";
	halo = "quest/objects/interface_button";
	position = { x = 570, y = 530 };
	image = "buttons/button_checklist";
	depth_mode = DEPTH.DEPTH_OVER_HUD;
	rolloversound = "audio/sfx/inv_rollover.ogg";
	say_spec = 
		{
			colour = { a = 1, r = 1, g = 1, b = 1 };
			y = 60,
			x = -5,
			w = 60,
			h = 50,
			lineheight = 15,
			bubble = false,
			outline_size = 0,
			anchor = ANCHOR.BOTTOM,
		};
	
	on_click = function(flo, button)
		button:StartProc(napkin_button_click);
	end;
};

function map_button_click(actor)
	lower_hud();
	while not hud_lowered() do
		delay(1);
	end
	scene:ChainToSubScene("map");
	wait_subscene();
	raise_hud();
end

map_button_spec = 
{
	name = "MAP_BUTTON";
	text = "";
	halo = "quest/objects/interface_button";
	position = { x = 505, y = 535 };
	image = "buttons/button_map";
	depth_mode = DEPTH.DEPTH_OVER_HUD;
	rolloversound = "audio/sfx/inv_rollover.ogg";
	say_spec = 
		{
			colour = { a = 1, r = 1, g = 1, b = 1 };
			y = 55,
			x = 0,
			w = 50,
			h = 50,
			bubble = false,
			outline_size = 0,
			anchor = ANCHOR.BOTTOM,
		};
		
	on_click = function(flo, button)
		button:StartProc(map_button_click);
	end;
};

function butterfly_button_click(actor)
	lower_hud();
	while not hud_lowered() do
		delay(1);
	end
	scene:ChainToSubScene("butterflylist");
	wait_subscene();
	raise_hud();
end

butterflybag_spec = 
{
	name = "BUTTERFLYBAG";
	text = "";
	halo = "quest/objects/interface_button";
	position = { x = 640, y = 524 };
	--position = { x = 200, y = 100 };
	image = "buttons/button_butterflies";
	depth_mode = DEPTH.DEPTH_OVER_HUD;
	rolloversound = "audio/sfx/inv_rollover.ogg";
	flags = AFLAG.AFLAG_TEXT_ON_ACTOR;
	say_spec = 
		{
			color = { a = 1, r = 1, g = 1, b = 1 },
			y = -524+30,
			x = -640+30,
			w = 60,
			h = 40,
			bubble = false,
			lineheight = 20,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	init = function(actor)
			if game:Get("butterfly_count") > 0 then
				actor:SayRaw(tostring(game:Get("butterfly_count")));
			end
		end;
	
	on_click = function(flo, button)
		button:StartProc(butterfly_button_click);
	end;
};

help_panel_spec = 
{
	name = "HELP_PANEL";
	gfx = { image = "quest/shared/help_panel" };
	
	command = function(actor)
		actor:JumpToPoint { x = 0, y = hud_lower_offset };
		--actor:SetDepthMode(DEPTH.DEPTH_OVER_HUD);
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 };
			y = 530,
			x = 80,
			w = 480,
			h = 100,
			font = "fonts/dom_casual_std.mvec",
			bubble_0 = help_bubble_spec,
			bubble_1 = help_bubble_spec,
			bubble = BUBBLE.BUBBLE_SHOW, 
			outline_size = 0,
			anchor = ANCHOR.CENTER,
			lineheight = 18,
			linepadding = -2,
			halign = HALIGN.CENTER,
		};
	end;
};

local help_panel_text_up = false;

function help_panel_say_raw(text)
	scene.HELP_PANEL:StartProc(function(help_panel)
		if text and text ~= "" then
			if help_panel_text_up == false then
				for i = 1, 5 do
					scene.HELP_PANEL:ModifySaySpec
					{
						bubble_0 = 
						{	bubble_file = "quest/shared/help_panel_bubble_000" .. i,
							bubble_mouth = { x = -120, y = -610 },
							bubble_box = { left = 70, top = 22, right = 410, bottom = 112 },
						};
						
						bubble_1 = 
						{	bubble_file = "quest/shared/help_panel_bubble_000" .. i,
							bubble_mouth = { x = -120, y = -610 },
							bubble_box = { left = 70, top = 22, right = 410, bottom = 112 },
						};
					};
					scene.HELP_PANEL:SayRaw(" ");
					delay(3);
				end
				
				help_panel_text_up = true;
			end
		
			scene.HELP_PANEL:SayRaw("<i>" .. string.upper(text) .. "</i>");
		else
			if help_panel_text_up then
				help_panel_text_up = false;
				for i = 5, 1, -1 do
					scene.HELP_PANEL:ModifySaySpec
					{
						bubble_0 = 
						{	bubble_file = "quest/shared/help_panel_bubble_000" .. i,
							bubble_mouth = { x = -120, y = -610 },
							bubble_box = { left = 70, top = 20, right = 410, bottom = 110 },
						};
						
						bubble_1 = 
						{	bubble_file = "quest/shared/help_panel_bubble_000" .. i,
							bubble_mouth = { x = -120, y = -610 },
							bubble_box = { left = 70, top = 20, right = 410, bottom = 110 },
						};
					};
					scene.HELP_PANEL:SayRaw(" ");
					delay(3);
				end
			end
			
			scene.HELP_PANEL:SayRaw("");
		end
	end);
end

help_panel_blink_spec = 
{
	name = "HELP_PANEL_BLINK";
	gfx = { anim = "anim/help_panel/blink" };
	
	command = function(actor)
		actor:JumpToPoint { x = 0, y = hud_lower_offset };
		--actor:SetDepthMode(DEPTH.DEPTH_OVER_HUD);
		actor:SetDepthValue(501);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:SetAlpha(0);
		
		while true do
			delay(math.random(200, 300));
			actor:SetAlpha(1);
			actor:PlayAnim("Blink");
			wait_anim();
			actor:SetAlpha(0);
		end
	end;
}

-- character speeds
flo_speed = 7.8;
gran_speed = 4.2;
cookie_speed = 4.2;
dinertoon1_speed = 4.2;
dinertoon2_speed = 4.2;
greg_speed = 4.2;
herb_speed = 4.2;
diane_speed = 4.2;
bernie_speed = 4.2;
stella_speed = 4.2;
ethel_speed = 4.2;
derek_speed = 4.2;
snookums_speed = 4.2;
cassie_speed = 4.2;
walter_speed = 4.2;
petspadog_speed = 4.2;
betty_speed = 4.2;
girlsprout1_speed = 4.2;
girlsprout2_speed = 4.2;
jo_speed = 4.2;
bodybuilder_speed = 4.2;
cubicle1_speed = 4.2;
cubicle2_speed = 4.2;
cubicle3_speed = 4.2;
cubicle4_speed = 4.2;
cubicle5_speed = 4.2;
barb_speed = 4.2;
secretary_speed = 4.2;
tina_speed = 4.2;
colin_speed = 4.2;
mrbig_speed = 4.2;
marco_speed = 4.2;
subway1_speed = 4.2;
subway2_speed = 4.2;
subway3_speed = 4.2;
hal_speed = 4.2;
bernie_speed = 4.2;
musician_speed = 4.2;
karma_speed = 4.2;
fireman_speed = 4.2;
simon_speed = 4.2;

-- character text heights
default_text_height = -220;
flo_text_height = -220;
gran_text_height = -220;
cookie_text_height = -220;
dinertoon1_text_height = -190;
dinertoon2_text_height = -190;
greg_text_height = -240;
herb_text_height = -240;
diane_text_height = -220;
bernie_text_height = -220;
ethel_text_height = -220;
derek_text_height = -240;
snookums_text_height = -150;
cassie_text_height = -220;
walter_text_height = -200;
petspadog_text_height = -140;
betty_text_height = -220;
bobbie_text_height = -210;
beadmachine_text_height = -220;
stella_text_height = -220;
ernie_text_height = -220;
ernie_bus_text_height = 0;
daniel_text_height = -220;
girlsprout1_text_height = -220;
girlsprout2_text_height = -220;
jo_text_height = -220;
bodybuilder_text_height = -220;
cubicle1_text_height = -190;
cubicle2_text_height = -190;
cubicle3_text_height = -190;
cubicle4_text_height = -190;
cubicle5_text_height = -190;
barb_text_height = -190;
secretary_text_height = -190;
tina_text_height = -190;
colin_text_height = -190;
mrbig_text_height = -240;
marco_text_height = -220;
subway1_text_height = -190;
subway2_text_height = -190;
subway3_text_height = -190;
hal_text_height = -190;
bernie_text_height = -190;
musician_text_height = -190;
karma_text_height = -190;
fireman_text_height = -190;
simon_text_height = -190;

bubble_spec_a0 =
{
	bubble_file = "quest/shared/bubble_a_small",
	bubble_mouth = { x = 170, y = 168},
	bubble_box = { left = 80, top = 47, right = 275, bottom = 119 },
};

bubble_spec_a1 =
{
	bubble_file = "quest/shared/bubble_a",
	bubble_mouth = { x = 170, y = 180 },
	bubble_box = { left = 35, top = 27, right = 300, bottom = 115 },
};

bubble_b0_spec =
{
	bubble_file = "quest/shared/bubble_b_small",
	bubble_mouth = { x = 343 - (295 - 279), y = 180 },
	bubble_box = { left = 79, top = 45, right = 276, bottom = 117 },
};

bubble_b1_spec =
{
	bubble_file = "quest/shared/bubble_b",
	bubble_mouth = { x = 343, y = 180 },
	bubble_box = { left = 37, top = 27, right = 301, bottom = 115 },
};

help_bubble_spec =
{
	bubble_file = "quest/shared/help_panel_speech_bubble",
	bubble_mouth = { x = -120, y = -615 },
	bubble_box = { left = 60, top = 20, right = 430, bottom = 115 },
};

thoughtbubble_spec =
{
	bubble_file = "quest/shared/bubble_c",
	bubble_mouth = { x = 95, y = 283 },
	bubble_box = { left = 30, top = 19, right = 140, bottom = 125 },
};

-- character text colours
default_text_color = { a = 1, r = 0, g = 0, b = 0 };
flo_text_color = { a = 1, r = 0, g = 0, b = 0 };
gran_text_color = { a = 1, r = 0, g = 0, b = 0 };
cookie_text_color = { a = 1, r = 0, g = 0, b = 0 };
dinertoon1_text_color = { a = 1, r = 0, g = 0, b = 0 };
dinertoon2_text_color = { a = 1, r = 0, g = 0, b = 0 };
greg_text_color = { a = 1, r = 0, g = 0, b = 0 };
herb_text_color = { a = 1, r = 0, g = 0, b = 0 };
diane_text_color = { a = 1, r = 0, g = 0, b = 0 };
bernie_text_color = { a = 1, r = 0, g = 0, b = 0 };
ethel_text_color = { a = 1, r = 0, g = 0, b = 0 };
derek_text_color = { a = 1, r = 0, g = 0, b = 0 };
snookums_text_color = { a = 1, r = 0, g = 0, b = 0 };
cassie_text_color = { a = 1, r = 0, g = 0, b = 0 };
walter_text_color = { a = 1, r = 0, g = 0, b = 0 };
petspadog_text_color = { a = 1, r = 0, g = 0, b = 0 };
betty_text_color = { a = 1, r = 0, g = 0, b = 0 };
bobbie_text_color = { a = 1, r = 0, g = 0, b = 0 };
beadmachine_text_color = { a = 1, r = 0, g = 0, b = 0 };
stella_text_color = { a = 1, r = 0, g = 0, b = 0 };
ernie_text_color = { a = 1, r = 0, g = 0, b = 0 };
ernie_bus_text_color = { a = 1, r = 0, g = 0, b = 0 };
daniel_bus_text_color = { a = 1, r = 0, g = 0, b = 0 };
girlsprout1_text_color = { a = 1, r = 0, g = 0, b = 0 };
girlsprout2_text_color = { a = 1, r = 0, g = 0, b = 0 };
jo_text_color = { a = 1, r = 0, g = 0, b = 0 };
bodybuilder_text_color = { a = 1, r = 0, g = 0, b = 0 };
cubicle1_text_color = { a = 1, r = 0, g = 0, b = 0 };
cubicle2_text_color = { a = 1, r = 0, g = 0, b = 0 };
cubicle3_text_color = { a = 1, r = 0, g = 0, b = 0 };
cubicle4_text_color = { a = 1, r = 0, g = 0, b = 0 };
cubicle5_text_color = { a = 1, r = 0, g = 0, b = 0 };
barb_text_color = { a = 1, r = 0, g = 0, b = 0 };
secretary_text_color = { a = 1, r = 0, g = 0, b = 0 };
tina_text_color = { a = 1, r = 0, g = 0, b = 0 };
colin_text_color = { a = 1, r = 0, g = 0, b = 0 };
mrbig_text_color = { a = 1, r = 0, g = 0, b = 0 };
marco_text_color = { a = 1, r = 0, g = 0, b = 0 };
subway1_text_color = { a = 1, r = 0, g = 0, b = 0 };
subway2_text_color = { a = 1, r = 0, g = 0, b = 0 };
subway3_text_color = { a = 1, r = 0, g = 0, b = 0 };
hal_text_color = { a = 1, r = 0, g = 0, b = 0 };
bernie_text_color = { a = 1, r = 0, g = 0, b = 0 };
musician_text_color = { a = 1, r = 0, g = 0, b = 0 };
karma_text_color = { a = 1, r = 0, g = 0, b = 0 };
fireman_text_color = { a = 1, r = 0, g = 0, b = 0 };
simon_text_color = { a = 1, r = 0, g = 0, b = 0 };

common_text_spec = 
{
	color = default_text_color,
	y = default_text_height, 
	w = 340, h = 250, 
	x = -170,
	font = "fonts/dom_casual_std.mvec",
	clamp = CLAMP.CLAMP_SCREEN,
	bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_AUTOFLIP + BUBBLE.BUBBLE_AUTOVFLIP, 
	outline_size = 0, 
	anchor = ANCHOR.CENTER,
	mouth_in_actor = { x = 0, y = -115 },
	bubble_file = "quest/shared/bubble_a",
	bubble_mouth = { x = 170, y = 180 },
	bubble_box = { left = 35, top = 27, right = 301, bottom = 115 },
}

-- use this generally like this - actor::ModifySaySpec(flo_text_spec);
flo_text_spec = { color = flo_text_color, y = flo_text_height, mouth_in_actor = { x = 0, y = -165 } };
gran_text_spec = { color = gran_text_color, y = gran_text_height, mouth_in_actor = { x = 0, y = -130 } };
cookie_text_spec = { color = cookie_text_color, y = cookie_text_height, mouth_in_actor = { x = -70, y = -60 }, bubble_0 = bubble_b0_spec, bubble_1 = bubble_b1_spec, };
dinertoon1_text_spec = { color = dinertoon1_text_color, y = dinertoon1_text_height, mouth_in_actor = { x = 0, y = -120 }, };
dinertoon2_text_spec = { color = dinertoon2_text_color, y = dinertoon2_text_height, mouth_in_actor = { x = 0, y = -100 }, };
greg_text_spec = { color = greg_text_color, y = greg_text_height, mouth_in_actor = { x = 10, y = -110 }, bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP + BUBBLE.BUBBLE_FORCEVFLIP  };
herb_text_spec = { color = herb_text_color, y = herb_text_height, mouth_in_actor = { x = -20, y = -110 }, bubble_0 = bubble_b0_spec, bubble_1 = bubble_b1_spec, bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP + BUBBLE.BUBBLE_AUTOVFLIP};
diane_text_spec = { color = diane_text_color, y = diane_text_height, mouth_in_actor = { x = 5, y = -100 } };
bernie_text_spec = { color = bernie_text_color, y = bernie_text_height, mouth_in_actor = { x = 0, y = -140 }};
ethel_text_spec = { color = ethel_text_color, y = ethel_text_height };
derek_text_spec = { color = derek_text_color, y = derek_text_height, mouth_in_actor = { x = 0, y = -150 } };
snookums_text_spec = { color = snookums_text_color, y = snookums_text_height };
cassie_text_spec = { color = cassie_text_color, y = cassie_text_height, mouth_in_actor = { x = 0, y = -180 } };
walter_text_spec = { color = walter_text_color, y = walter_text_height, mouth_in_actor = { x = 10, y = -145 }};
petspadog_text_spec = { color = petspadog_text_color, y = petspadog_text_height, mouth_in_actor = { x = 0, y = -140 }};
betty_text_spec = { color = betty_text_color, y = betty_text_height, mouth_in_actor = { x = 0, y = -230 } };
bobbie_text_spec = { color = bobbie_text_color, y = bobbie_text_height };
beadmachine_text_spec = { color = bobbie_text_color, y = bobbie_text_height };
stella_text_spec = { color = stella_text_color, y = stella_text_height, mouth_in_actor = { x = -40, y = -180 } };
ernie_text_spec = { color = ernie_text_color, y = ernie_text_height, mouth_in_actor = { x = -25, y = -105 } };
ernie_bus_text_spec = { color = ernie_bus_text_color, y = ernie_bus_text_height, mouth_in_actor = { x = -75, y = -165 } };
daniel_text_spec = { color = daniel_text_color, y = daniel_text_height, mouth_in_actor = { x = 0, y = -140 }, bubble_0 = bubble_b0_spec, bubble_1 = bubble_b1_spec, bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP};
girlsprout1_text_spec = { color = girlsprout1_text_color, y = girlsprout1_text_height, mouth_in_actor = { x = -20, y = -80 } };
girlsprout2_text_spec = { color = girlsprout2_text_color, y = girlsprout2_text_height, mouth_in_actor = { x = -15, y = -80 } };
jo_text_spec = { color = jo_text_color, y = jo_text_height, mouth_in_actor = { x = 0, y = -160 }};
bodybuilder_text_spec = { color = bodybuilder_text_color, y = bodybuilder_text_height, mouth_in_actor = { x = 0, y = -160 }};
cubicle1_text_spec = { color = cubicle1_text_color, y = cubicle1_text_height, mouth_in_actor = { x = 0, y = -100 }, };
cubicle2_text_spec = { color = cubicle2_text_color, y = cubicle2_text_height, mouth_in_actor = { x = 0, y = -100 }, };
cubicle3_text_spec = { color = cubicle3_text_color, y = cubicle3_text_height, mouth_in_actor = { x = 0, y = -100 }, };
cubicle4_text_spec = { color = cubicle4_text_color, y = cubicle4_text_height, mouth_in_actor = { x = 0, y = -100 }, };
cubicle5_text_spec = { color = cubicle4_text_color, y = cubicle4_text_height, mouth_in_actor = { x = 0, y = -100 }, };
barb_text_spec = { color = barb_text_color, y = barb_text_height, mouth_in_actor = { x = 0, y = -160 }, };
secretary_text_spec = { color = secretary_text_color, y = secretary_text_height, mouth_in_actor = { x = 0, y = -100 },  };
tina_text_spec = { color = tina_text_color, y = tina_text_height, mouth_in_actor = { x = 0, y = -80 }, };
colin_text_spec = { color = colin_text_color, y = colin_text_height, mouth_in_actor = { x = 0, y = -140 }, };
quizbot_text_spec = { color = default_text_color, y = default_text_height, mouth_in_actor = { x = -20, y = -120 }, bubble_0 = bubble_b0_spec, bubble_1 = bubble_b1_spec, bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP + BUBBLE.BUBBLE_FORCEVFLIP };
mrbig_text_spec = { color = mrbig_text_color, y = mrbig_text_height };
marco_text_spec = { color = marco_text_color, y = marco_text_height, mouth_in_actor = { x = 0, y = -175 }};
subway1_text_spec = { color = subway1_text_color, y = subway1_text_height, mouth_in_actor = { x = 0, y = -130 }, };
subway2_text_spec = { color = subway2_text_color, y = subway2_text_height, mouth_in_actor = { x = 0, y = -140 }, };
subway3_text_spec = { color = subway3_text_color, y = subway3_text_height, mouth_in_actor = { x = 0, y = -100 }, };
hal_text_spec = { color = hal_text_color, y = hal_text_height, mouth_in_actor = { x = 0, y = -135 }, };
musician_text_spec = { color = musician_text_color, y = musician_text_height, mouth_in_actor = { x = 0, y = -100 }, };
karma_text_spec = { color = karma_text_color, y = karma_text_height, mouth_in_actor = { x = 0, y = -130 }, };
fireman_text_spec = { color = fireman_text_color, y = fireman_text_height, mouth_in_actor = { x = -20, y = -105 }, bubble_0 = bubble_b0_spec, bubble_1 = bubble_b1_spec, bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP };
hen_text_spec = { color = default_text_color, y = default_text_height, mouth_in_actor = { x = 330, y = 130 }, };
simon_text_spec = { color = simon_text_color, y = simon_text_height, mouth_in_actor = { x = 0, y = -140 } };

-- inventory descriptions
inv_desc_coffeecup = 
{
	key = "coffeecup", 
	text = "inv_coffeecup", 
	anim = "inv/inv_coffeecup",
	cursor = "inv/cur_coffeecup",
	cantuse = "inv_coffeecup_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_mop = 
{
	key = "mop", 
	text = "inv_mop", 
	anim = "inv/inv_mop",
	cursor = "inv/cur_mop",
	cantuse = "inv_mop_cantuse",
	cursor_hot = { x = 31, y = 44 },
};

inv_desc_dye = 
{
	key = "dye", 
	text = "inv_dye", 
	anim = "inv/inv_dye",
	cursor = "inv/cur_dye",
	cantuse = "inv_dye_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_oil = 
{
	key = "oil", 
	text = "inv_oil", 
	anim = "inv/inv_oil",
	cursor = "inv/cur_oil",
	cantuse = "inv_oil_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_screwdriver= 
{
	key = "screwdriver", 
	text = "inv_screwdriver", 
	anim = "inv/inv_screwdriver",
	cursor = "inv/cur_screwdriver",
	cantuse = "inv_screwdriver_cantuse",
	cursor_hot = { x = 0, y = 0 },
};

inv_desc_wirecutters = 
{
	key = "wirecutters", 
	text = "inv_wirecutters", 
	anim = "inv/inv_wirecutters",
	cursor = "inv/cur_wirecutters",
	cantuse = "inv_wirecutters_cantuse",
	cursor_hot = { x = 40, y = 4 },
};

inv_desc_beads = 
{
	key = "beads", 
	text = "inv_beads", 
	anim = "inv/inv_beads",
	cursor = "inv/cur_beads",
	cantuse = "inv_beads_cantuse",
	cursor_hot = { x = 25, y = 25 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_beadcollection = 
{
	key = "beadcollection", 
	text = "inv_beadcollection", 
	anim = "inv/inv_beadcollection",
	--bar_anim = "inv/inv_beadcollection_num",
	cursor = "inv/cur_beadcollection",
	cantuse = "inv_beadcollection_cantuse",
	cursor_hot = { x = 10, y = 27 },
	--overtext = "0 10",
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_snookums = 
{
	key = "snookums", 
	text = "inv_snookums", 
	anim = "inv/inv_snookums",
	cursor = "inv/cur_snookums",
	cantuse = "inv_snookums_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_dogtreat = 
{
	key = "dogtreat", 
	text = "inv_dogtreat", 
	anim = "inv/inv_dogtreat",
	cursor = "inv/cur_dogtreat",
	cantuse = "inv_dogtreat_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_dyeremover = 
{
	key = "dyeremover", 
	text = "inv_dyeremover", 
	anim = "inv/inv_dyeremover",
	cursor = "inv/cur_dyeremover",
	cantuse = "inv_dyeremover_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_garmentpole = 
{
	key = "garmentpole", 
	text = "inv_garmentpole", 
	anim = "inv/inv_garmentpole",
	cursor = "inv/cur_garmentpole",
	cantuse = "inv_garmentpole_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_curtains = 
{
	key = "curtains", 
	text = "inv_curtains", 
	anim = "inv/inv_curtains",
	cursor = "inv/cur_curtains",
	cantuse = "inv_curtains_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_recyclable = 
{
	key = "recyclable", 
	text = "inv_recyclable", 
	anim = "inv/inv_recyclable",
	--bar_anim = "inv/inv_recyclable_num",
	cursor = "inv/cur_recyclable",
	cantuse = "inv_recyclable_cantuse",
	cursor_hot = { x = 17, y = 20 },
	--overtext = "1",
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_token = 
{
	key = "token", 
	text = "inv_token", 
	anim = "inv/inv_token",
	--bar_anim = "inv/inv_token_num",
	cursor = "inv/cur_token",
	cantuse = "inv_token_cantuse",
	cursor_hot = { x = 25, y = 25 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_gold_token = 
{
	key = "gold_token", 
	text = "inv_gold_token", 
	anim = "inv/inv_gold_token",
	cursor = "inv/cur_gold_token",
	cantuse = "inv_gold_token_cantuse",
	cursor_hot = { x = 25, y = 25 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_lugnut = 
{
	key = "lugnut", 
	text = "inv_lugnut", 
	anim = "inv/inv_lugnut",
	cursor = "inv/cur_lugnut",
	cantuse = "inv_lugnut_cantuse",
	cursor_hot = { x = 25, y = 25 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_lugnutcollection = 
{
	key = "lugnutcollection", 
	text = "inv_lugnutcollection", 
	anim = "inv/inv_lugnutcollection",
	--bar_anim = "inv/inv_lugnutcollection_num",
	cursor = "inv/cur_lugnutcollection",
	cantuse = "inv_lugnutcollection_cantuse",
	cursor_hot = { x = 10, y = 27 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_recipe = 
{
	key = "recipe", 
	text = "inv_recipe", 
	anim = "inv/inv_recipe",
	cursor = "inv/cur_recipe",
	cantuse = "inv_recipe_cantuse",
	cursor_hot = { x = 10, y = 27 },
};

inv_desc_vhstape = 
{
	key = "vhstape", 
	text = "inv_vhstape", 
	anim = "inv/inv_vhstape",
	cursor = "inv/cur_vhstape",
	cantuse = "inv_vhstape_cantuse",
	cursor_hot = { x = 10, y = 27 },
};

inv_desc_egg = 
{
	key = "egg", 
	text = "inv_egg", 
	anim = "inv/inv_egg",
	--bar_anim = "inv/inv_egg_num",
	cursor = "inv/cur_egg",
	cantuse = "inv_egg_cantuse",
	cursor_hot = { x = 10, y = 27 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_cookies = 
{
	key = "cookies", 
	text = "inv_cookies", 
	anim = "inv/inv_cookies",
	cursor = "inv/cur_cookies",
	cantuse = "inv_cookies_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_card = 
{
	key = "card", 
	text = "inv_card", 
	anim = "inv/inv_card",
	--bar_anim = "inv/inv_card_num",
	cursor = "inv/cur_card",
	cantuse = "inv_card_cantuse",
	cursor_hot = { x = 27, y = 35 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_keycard = 
{
	key = "keycard", 
	text = "inv_keycard", 
	anim = "inv/inv_keycard",
	cursor = "inv/cur_keycard",
	cantuse = "inv_keycard_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_mugcollection = 
{
	key = "mugcollection", 
	text = "inv_mugcollection", 
	anim = "inv/inv_mugcollection",
	--bar_anim = "inv/inv_mugcollection_num",
	cursor = "inv/cur_mugcollection",
	cantuse = "inv_mugcollection_cantuse",
	cursor_hot = { x = 25, y = 25 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_mugs = 
{
	key = "mugs", 
	text = "inv_mugs", 
	anim = "inv/inv_mugs",
	--bar_anim = "inv/inv_mugcollection_num",
	cursor = "inv/cur_mugs",
	cantuse = "inv_mugs_cantuse",
	cursor_hot = { x = 25, y = 25 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_bluekey = 
{
	key = "bluekey", 
	text = "inv_bluekey", 
	anim = "inv/inv_bluekey",
	cursor = "inv/cur_bluekey",
	cantuse = "inv_bluekey_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_memo_pieces = 
{
	key = "memo_pieces", 
	text = "inv_memo_pieces", 
	anim = "inv/inv_memo_pieces",
	cursor = "inv/cur_memo_pieces",
	cantuse = "inv_memo_pieces_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_memocollection = 
{
	key = "memocollection", 
	text = "inv_memocollection", 
	anim = "inv/inv_memocollection",
	--bar_anim = "inv/inv_memocollection_num",
	cursor = "inv/cur_memocollection",
	cantuse = "inv_memocollection_cantuse",
	cursor_hot = { x = 25, y = 25 },
	overtext_color = { a = 1, r = 1, g = 1, b = 1 },
};

inv_desc_memo = 
{
	key = "memo", 
	text = "inv_memo", 
	anim = "inv/inv_memo",
	cursor = "inv/cur_memo",
	cantuse = "inv_memo_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_permit = 
{
	key = "permit", 
	text = "inv_permit", 
	anim = "inv/inv_permit",
	cursor = "inv/cur_permit",
	cantuse = "inv_permit_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_permit_signed = 
{
	key = "permit_signed", 
	text = "inv_permit_signed", 
	anim = "inv/inv_permit_signed",
	cursor = "inv/cur_permit_signed",
	cantuse = "inv_permit_signed_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_permit_stamped = 
{
	key = "permit_stamped", 
	text = "inv_permit_stamped", 
	anim = "inv/inv_permit_stamped",
	cursor = "inv/cur_permit_stamped",
	cantuse = "inv_permit_stamped_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_orange_pen = 
{
	key = "orange_pen", 
	text = "inv_orange_pen", 
	anim = "inv/inv_orange_pen",
	cursor = "inv/cur_orange_pen",
	cantuse = "inv_orange_pen_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_key = 
{
	key = "key", 
	text = "inv_key", 
	anim = "inv/inv_key",
	cursor = "inv/cur_key",
	cantuse = "inv_key_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

inv_desc_revealer = 
{
	key = "revealer", 
	text = "inv_revealer", 
	anim = "inv/inv_revealer",
	cursor = "inv/cur_revealer",
	cantuse = "inv_revealer_cantuse",
	cursor_hot = { x = 3, y = 48 },
};

inv_desc_rings = 
{
	key = "rings", 
	text = "inv_rings", 
	anim = "inv/inv_rings",
	cursor = "inv/cur_rings",
	cantuse = "inv_rings_cantuse",
	cursor_hot = { x = 25, y = 25 },
};

-- handle flo's generic inventory item response
function flo_inv_generic(flo, item)
	flo:StartProc(
		function(flo)
			if item == "dogtreat" then
				scene:SetMode(MODE.DIALOG);
				if game:Get("used_dogtreat_on_flo") < 1 then
					run_super_conversation(flo, "misused_dogtreat_a");
					game:Set("used_dogtreat_on_flo", 1);
				else
					run_super_conversation(flo, "misused_dogtreat_b");
				end
				flo:SetMode(MODE.FOLLOWCLICKS);
			elseif item == "cookies" then
				scene:SetMode(MODE.DIALOG);
				if game:Get("used_cookies_on_flo") < 1 then
					run_super_conversation(flo, "misused_cookies_a");
					game:Set("used_cookies_on_flo", 1);
				else
					run_super_conversation(flo, "misused_cookies_b");
				end
				flo:SetMode(MODE.FOLLOWCLICKS);
			else
				on_use_inv(item, flo, flo);
			end
		end
	);
end
